---
title: Features by plan type · Cloudflare Cache (CDN) docs
description: Cloudflare provides the following features for different plans.
lastUpdated: 2025-08-18T14:27:42.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cache/plans/
  md: https://developers.cloudflare.com/cache/plans/index.md
---

Cloudflare provides the following features for different [plans](https://www.cloudflare.com/plans/).

## Features

### Always Online

**Link:** [Always Online](https://developers.cloudflare.com/cache/how-to/always-online/)

**Feature availability**

* **Free:** Yes
* **Pro:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Crawl interval**

Available on all plans

* **Free:** Every 30 days
* **Pro:** Every 15 days
* **Business:** Every 5 days
* **Enterprise:** Every 5 days

### Browser Cache TTL

**Link:** [Browser Cache TTL](https://developers.cloudflare.com/cache/how-to/edge-browser-cache-ttl/)

**Feature availability**

* **Free:** Yes
* **Pro:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Minimum Browser Cache TTL (Page Rules)**

* **Free:** 2 minutes
* **Pro:** 2 minutes
* **Business:** 2 minutes
* **Enterprise:** 30 seconds

**Minimum Browser Cache TTL**

* **Free:** 1 second
* **Pro:** 1 second
* **Business:** 1 second
* **Enterprise:** 1 second

**Default Browser Cache TTL**

* **Free:** 4 hours
* **Pro:** 4 hours
* **Business:** 4 hours
* **Enterprise:** 4 hours

### Cache analytics

**Link:** [Cache analytics](https://developers.cloudflare.com/cache/performance-review/cache-analytics/)

**Feature availability**

* **Free:** No
* **Pro:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Retention period**

* **Free:** N/A
* **Pro:** 7 days
* **Business:** 30 days
* **Enterprise:** 30 days

### Cache keys

**Link:** [Cache keys](https://developers.cloudflare.com/cache/how-to/cache-keys/)

**Cache deception armor**

* **Free:** Yes
* **Pro:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Cache by device type**

* **Free:** Yes
* **Pro:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Ignore query string**

* **Free:** Yes
* **Pro:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Sort query string**

* **Free:** Yes
* **Pro:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Query string**

* **Free:** No
* **Pro:** No
* **Business:** No
* **Enterprise:** Yes

**Headers**

* **Free:** No
* **Pro:** No
* **Business:** No
* **Enterprise:** Yes

**Cookie**

* **Free:** No
* **Pro:** No
* **Business:** No
* **Enterprise:** Yes

**Host**

* **Free:** No
* **Pro:** No
* **Business:** No
* **Enterprise:** Yes

**User features**

* **Free:** No
* **Pro:** No
* **Business:** No
* **Enterprise:** Yes

### Set caching level

**Link:** [Set caching level](https://developers.cloudflare.com/cache/how-to/set-caching-levels/)

**Feature availability**

* **Free:** Yes
* **Pro:** Yes
* **Business:** Yes
* **Enterprise:** Yes

### Cache reserve

**Link:** [Cache reserve](https://developers.cloudflare.com/cache/advanced-configuration/cache-reserve/)

**Feature availability**

* **Free:** Paid add-on
* **Pro:** Paid add-on
* **Business:** Paid add-on
* **Enterprise:** Paid add-on

### Cache Rules

**Link:** [Cache Rules](https://developers.cloudflare.com/cache/how-to/cache-rules/)

**Feature availability**

* **Free:** Yes
* **Pro:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Number of rules**

* **Free:** 10
* **Pro:** 25
* **Business:** 50
* **Enterprise:** 300

### Cache by status code

**Link:** [Cache by status code](https://developers.cloudflare.com/cache/how-to/configure-cache-status-code/)

**Feature availability**

* **Free:** No
* **Pro:** No
* **Business:** No
* **Enterprise:** Yes

### Crawler Hints

**Link:** [Crawler Hints](https://developers.cloudflare.com/cache/advanced-configuration/crawler-hints/)

**Feature availability**

* **Free:** Yes
* **Pro:** Yes
* **Business:** Yes
* **Enterprise:** Yes

### CSAM Scanning Tool

**Link:** [CSAM Scanning Tool](https://developers.cloudflare.com/cache/reference/csam-scanning/)

**Feature availability**

* **Free:** Yes
* **Pro:** Yes
* **Business:** Yes
* **Enterprise:** Yes

### Development mode

**Link:** [Development mode](https://developers.cloudflare.com/cache/reference/development-mode/)

**Feature availability**

* **Free:** Yes
* **Pro:** Yes
* **Business:** Yes
* **Enterprise:** Yes

### Edge Cache TTL

**Link:** [Edge Cache TTL](https://developers.cloudflare.com/cache/how-to/edge-browser-cache-ttl/)

**Feature availability**

* **Free:** Yes
* **Pro:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Minimum Edge Cache TTL**

* **Free:** 2 hours
* **Pro:** 1 hour
* **Business:** 1 second
* **Enterprise:** 1 second

### ETag Headers

**Link:** [ETag Headers](https://developers.cloudflare.com/cache/reference/etag-headers/)

**Feature availability**

* **Free:** Yes
* **Pro:** Yes
* **Business:** Yes
* **Enterprise:** Yes

### Purge cache

**Link:** [Purge cache](https://developers.cloudflare.com/cache/how-to/purge-cache/)

**Feature availability**

* **Free:** Yes
* **Pro:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Purge options**

* **Free:** URL, Hostname, Tag, Prefix, and Purge Everything
* **Pro:** URL, Hostname, Tag, Prefix, and Purge Everything
* **Business:** URL, Hostname, Tag, Prefix, and Purge Everything
* **Enterprise:** URL, Hostname, Tag, Prefix, and Purge Everything

### Purge limits for hostname, tag, prefix URL, and purge everything.

**Link:** [Purge limits for hostname, tag, prefix URL, and purge everything.](https://developers.cloudflare.com/cache/how-to/purge-cache/)

**Requests**

Available on all plans

* **Free:** 5 requests per minute
* **Pro:** 5 requests per second
* **Business:** 10 requests per second
* **Enterprise:** 50 requests per second

**Bucket size**

* **Free:** 25
* **Pro:** 25
* **Business:** 50
* **Enterprise:** 500

**Max operations per request**

* **Free:** 100
* **Pro:** 100
* **Business:** 100
* **Enterprise:** 100

### Single file purge

**Link:** [Single file purge](https://developers.cloudflare.com/cache/how-to/purge-cache/purge-by-single-file/)

**URLs**

Available on all plans

* **Free:** 800 URLs per second
* **Pro:** 1500 URLs per second
* **Business:** 1500 URLs per second
* **Enterprise:** 3000 URLs per second

**Max operations per request**

* **Free:** 100
* **Pro:** 100
* **Business:** 100
* **Enterprise:** 500

### Query string sort

**Link:** [Query string sort](https://developers.cloudflare.com/cache/advanced-configuration/query-string-sort/)

**Feature availability**

* **Free:** No
* **Pro:** No
* **Business:** No
* **Enterprise:** Yes

### Tiered cache

**Link:** [Tiered cache](https://developers.cloudflare.com/cache/how-to/tiered-cache/)

**Tiered Cache**

Available on all plans

* **Free:** Yes
* **Pro:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Smart Topology**

* **Free:** Yes
* **Pro:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Generic Global Topology**

* **Free:** No
* **Pro:** No
* **Business:** No
* **Enterprise:** Yes

**Regional Tiered Cache**

* **Free:** No
* **Pro:** No
* **Business:** No
* **Enterprise:** Yes

**Custom Topology**

* **Free:** No
* **Pro:** No
* **Business:** No
* **Enterprise:** Yes

### Vary for images

**Link:** [Vary for images](https://developers.cloudflare.com/cache/advanced-configuration/vary-for-images/)

**Feature availability**

* **Free:** No
* **Pro:** Yes
* **Business:** Yes
* **Enterprise:** Yes
